function [W,W2,A1w,A2w] = localwarpAugment(I1,I2,A1,A2,surfaceMaxHeight,showSurf,warpTogether)
%LOCALWARPAUGMENT Create a bumpy surface and project the image onto this

if(surfaceMaxHeight > 100)
    disp("Caution: localwarpAugment is only accurate for small warp values, manually inspect the output to verify bounding boxes are still accurate");
end

[x, y] = meshgrid(1:size(I1,2), 1:size(I1,1));

%Generate smooth 3D surface
% Z = peaks(size(I1,1)); %Alternative warp function

N = [500 500];
F = 3;        % frequency-filter width

[X,Y] = ndgrid(1:N(1),1:N(2));
i = min(X-1,N(1)-X+1);
j = min(Y-1,N(2)-Y+1);
H = exp(-.5*(i.^2+j.^2)/F^2);
Z = real(ifft2(H.*fft2(randn(N))));
Z = imresize(Z,size(I1,1)/N(1));

%Scale the warp
assert(max(isnan(Z(:))) == 0);
[fx,fy] = gradient(Z);
surfHeight = max([fx(:);fy(:)]);
fx = fx*surfaceMaxHeight/(surfHeight);
fy = fy*surfaceMaxHeight/(surfHeight);

if(showSurf)
    figure();
    plot3(x,y,Z);
end

% Apply the warp
xwarp = x-fx;
ywarp = y-fy;

W(:,:,1) = interp2(double(I1(:,:,1)), xwarp, ywarp,'linear',255);
W(:,:,2) = interp2(double(I1(:,:,2)), xwarp, ywarp,'linear',255);
W(:,:,3) = interp2(double(I1(:,:,3)), xwarp, ywarp,'linear',255);
W = uint8(W);

%Warp annotations
A1w = [];
[rows, cols, ~] = size(I1);
for r = 1:size(A1,1)
    % find top left corner
    w = A1(r,4);
    h = A1(r,5);
    top = min(rows,max(1,round((A1(r,3) - h/2)*rows)));
    bottom = min(rows,max(1,round((A1(r,3) + h/2)*rows)));
    left = min(cols,max(1,round((A1(r,2) - w/2)*cols)));
    right = min(cols,max(1,round((A1(r,2) + w/2)*cols)));

    tl = [top,left];
    tr = [top,right];
    bl = [bottom,left];
    br = [bottom,right];

    %The warp is an index map for where each pixel should source its
    %infromation from. so the lazy way of transforming the annotation is to
    %search the warp map for the coordiantes which point to where the
    %bounding box was originally
    
    %Find warp map coords nearest point
    warpDist = abs(sqrt((ywarp-tl(1)).^2 + (xwarp-tl(2)).^2));
    [~,tl] = min(warpDist,[],'all');
    [tl(1),tl(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],tl);

    warpDist = abs(sqrt((ywarp-tr(1)).^2 + (xwarp-tr(2)).^2));
    [~,tr] = min(warpDist,[],'all');
    [tr(1),tr(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],tr);

    warpDist = abs(sqrt((ywarp-bl(1)).^2 + (xwarp-bl(2)).^2));
    [~,bl] = min(warpDist,[],'all');
    [bl(1),bl(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],bl);

    warpDist = abs(sqrt((ywarp-br(1)).^2 + (xwarp-br(2)).^2));
    [~,br] = min(warpDist,[],'all');
    [br(1),br(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],br);

    %Remove annotations warped out of image area. No longer the case that
    %left<right, top<bottom so have to check all 4
    if(tl(1)<1 || tl(1)>rows || tl(2)<1 || tl(2)>cols)
        disp("Skipping annotation")
        fprintf('Top left col,row = %d,%d \n',tl(2),tl(1));
        continue;
    elseif(tr(1)<1 || tr(1)>rows || tr(2)<1 || tr(2)>cols)
        disp("Skipping annotation")
        fprintf('Top right col,row = %d,%d \n',tr(2),tr(1));
        continue;
    elseif(bl(1)<1 || bl(1)>rows || bl(2)<1 || bl(2)>cols)
        disp("Skipping annotation")
        fprintf('Bottom left col,row = %d,%d \n',bl(2),bl(1));
        continue;
    elseif(br(1)<1 || br(1)>rows || br(2)<1 || br(2)>cols)
        disp("Skipping annotation")
        fprintf('Bottom right col,row = %d,%d \n',br(2),br(1));
        continue;
    end

    ax = (tr(2)+tl(2))/2;
    ay = (tl(1)+bl(1))/2;
    w = (tr(2)-tl(2));
    h = (bl(1)-tl(1));
    
    %check for boxes with bad dimensions
    if(w<0 || w>cols || h<0 || h>rows)
        disp("Localwarp skipping bad annotation (negative dimension or larger than image)")
        continue
    end    

    %Put back in relative coords
    A1w(end+1,1) = A1(r,1);
    A1w(end,2) = ax/cols;
    A1w(end,3) = ay/rows;
    A1w(end,4) = w/cols;
    A1w(end,5) = h/rows;

end

if(~warpTogether)
    %Make new warp map for 2nd img
    N = [500 500];
    F = 3;        % frequency-filter width
    
    [X,Y] = ndgrid(1:N(1),1:N(2));
    i = min(X-1,N(1)-X+1);
    j = min(Y-1,N(2)-Y+1);
    H = exp(-.5*(i.^2+j.^2)/F^2);
    Z = real(ifft2(H.*fft2(randn(N))));
    Z = imresize(Z,size(I1,1)/N(1));
    
    %Scale the warp
    assert(max(isnan(Z(:))) == 0);
    [fx,fy] = gradient(Z);
    surfHeight = max([fx(:);fy(:)]);
    fx = fx*surfaceMaxHeight/(surfHeight);
    fy = fy*surfaceMaxHeight/(surfHeight);
    
    if(showSurf)
        figure();
        plot3(x,y,Z);
    end

    xwarp = x-fx;
    ywarp = y-fy;
end

W2(:,:,1) = interp2(double(I2(:,:,1)), xwarp, ywarp,'linear',255);
W2(:,:,2) = interp2(double(I2(:,:,2)), xwarp, ywarp,'linear',255);
W2(:,:,3) = interp2(double(I2(:,:,3)), xwarp, ywarp,'linear',255);
W2 = uint8(W2);

%Warp annotations
A2w = [];
[rows, cols, ~] = size(I2);
for r = 1:size(A2,1)
    % find top left corner
    w = A2(r,4);
    h = A2(r,5);
    top = min(rows,max(1,round((A2(r,3) - h/2)*rows)));
    bottom = min(rows,max(1,round((A2(r,3) + h/2)*rows)));
    left = min(cols,max(1,round((A2(r,2) - w/2)*cols)));
    right = min(cols,max(1,round((A2(r,2) + w/2)*cols)));

    tl = [top,left];
    tr = [top,right];
    bl = [bottom,left];
    br = [bottom,right];

    %The warp is an index map for where each pixel should source its
    %infromation from. so the lazy way of transforming the annotation is to
    %search the warp map for the coordiantes which point to where the
    %bounding box was originally
    
    %Find warp map coords nearest point
    warpDist = abs(sqrt((ywarp-tl(1)).^2 + (xwarp-tl(2)).^2));
    [~,tl] = min(warpDist,[],'all');
    [tl(1),tl(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],tl);

    warpDist = abs(sqrt((ywarp-tr(1)).^2 + (xwarp-tr(2)).^2));
    [~,tr] = min(warpDist,[],'all');
    [tr(1),tr(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],tr);

    warpDist = abs(sqrt((ywarp-bl(1)).^2 + (xwarp-bl(2)).^2));
    [~,bl] = min(warpDist,[],'all');
    [bl(1),bl(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],bl);

    warpDist = abs(sqrt((ywarp-br(1)).^2 + (xwarp-br(2)).^2));
    [~,br] = min(warpDist,[],'all');
    [br(1),br(2)] = ind2sub([size(warpDist,1), size(warpDist,2)],br);

    %Remove annotations warped out of image area. No longer the case that
    %left<right, top<bottom so have to check all 4
    if(tl(1)<1 || tl(1)>rows || tl(2)<1 || tl(2)>cols)
        disp("Skipping annotation")
        fprintf('Top left col,row = %d,%d \n',tl(2),tl(1));
        continue;
    elseif(tr(1)<1 || tr(1)>rows || tr(2)<1 || tr(2)>cols)
        disp("Skipping annotation")
        fprintf('Top right col,row = %d,%d \n',tr(2),tr(1));
        continue;
    elseif(bl(1)<1 || bl(1)>rows || bl(2)<1 || bl(2)>cols)
        disp("Skipping annotation")
        fprintf('Bottom left col,row = %d,%d \n',bl(2),bl(1));
        continue;
    elseif(br(1)<1 || br(1)>rows || br(2)<1 || br(2)>cols)
        disp("Skipping annotation")
        fprintf('Bottom right col,row = %d,%d \n',br(2),br(1));
        continue;
    end

    ax = (tr(2)+tl(2))/2;
    ay = (tl(1)+bl(1))/2;
    w = (tr(2)-tl(2));
    h = (bl(1)-tl(1));
    
    %check for boxes with bad dimensions
    if(w<0 || w>cols || h<0 || h>rows)
        disp("Skipping bad annotation")
        continue
    end    

    %Put back in relative coords
    A2w(end+1,1) = A2(r,1);
    A2w(end,2) = ax/cols;
    A2w(end,3) = ay/rows;
    A2w(end,4) = w/cols;
    A2w(end,5) = h/rows;

end
% figure();
% drawAnnotations(W,A1w);
% figure();
% drawAnnotations(W2,A2w);

end